/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.entity.cow.shearable;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShearableCowEntity
extends Cow
implements Shearable {
    private static final EntityDataAccessor<Boolean> IsSHEARED = SynchedEntityData.m_135353_(ShearableCowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eatGrassTimer;
    private EatBlockGoal eatGrassGoal;
    private final Block wool;

    public ShearableCowEntity(EntityType<? extends Cow> entityType, Level world, Block wool) {
        super(entityType, world);
        this.wool = wool;
    }

    public InteractionResult m_6071_(Player player2, InteractionHand hand) {
        ItemStack itemStack = player2.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (!this.f_19853_.f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player2);
                itemStack.m_41622_(1, (LivingEntity)player2, player -> player.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player2, hand);
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)this.wool, 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSheared(nbt.m_128471_("Sheared"));
    }

    public void m_8035_() {
        super.m_8035_();
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(5, (Goal)this.eatGrassGoal);
    }

    protected void m_8024_() {
        this.eatGrassTimer = this.eatGrassGoal.m_25213_();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.m_8107_();
    }

    public void setSheared(boolean sheared) {
        if (sheared) {
            this.f_19804_.m_135381_(IsSHEARED, (Object)true);
        } else {
            this.f_19804_.m_135381_(IsSHEARED, (Object)false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IsSHEARED, (Object)false);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(IsSHEARED);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_7822_(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.m_7822_(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        if (this.eatGrassTimer < 4) {
            return ((float)this.eatGrassTimer - delta) / 4.0f;
        }
        return -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        if (this.eatGrassTimer > 0) {
            return 0.62831855f;
        }
        return this.m_146909_() * ((float)Math.PI / 180);
    }
}

